import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Define the figure and axis
fig, ax = plt.subplots(figsize=(9, 11))

# Define colors for the elements
floor_color = 'lightgray'
passenger_color = 'blue'
fast_elevator_color = 'green'
slow_elevator_color = 'orange'

# Define floor properties
floor_height = 1.5
floor_width = 9
num_floors = 5

# Define legend elements
legend_elements = [
    patches.Patch(color=passenger_color, label='Passenger'),
    patches.Patch(color=fast_elevator_color, label='Fast Elevator (0/2)'),
    patches.Patch(color=slow_elevator_color, label='Slow Elevator (0/1)')
]

# Draw the floors
for i in range(num_floors):
    y = i * floor_height
    ax.add_patch(patches.Rectangle((0, y), floor_width, floor_height, edgecolor='black', facecolor=floor_color))
    ax.text(0.1, y + floor_height / 2, f'floor_{i}', verticalalignment='center', fontsize=11, color='black')

# Draw passengers
passengers = {
    'p2': (0.5, 0),
    'p3': (1, 0),
    'p0': (0.5, floor_height),
    'p5': (1, floor_height),
    'p1': (0.5, 3 * floor_height),
    'p4': (1, 3 * floor_height),
}

for p_id, (px, py) in passengers.items():
    ax.add_patch(patches.Rectangle((px, py + 0.4), 0.4, 0.4, edgecolor='black', facecolor=passenger_color))
    ax.text(px + 0.2, py + 0.6, p_id, fontsize=9, color='white', ha='center', va='center')

# Draw elevators
elevators = {
    'fast0': (6.5, 0),
    'fast1': (7, 0),
    'slow0-0': (7.5, 0),
    'slow1-0': (7.5, 2 * floor_height),
}

for e_id, (ex, ey) in elevators.items():
    color = fast_elevator_color if 'fast' in e_id else slow_elevator_color
    ax.add_patch(patches.Rectangle((ex, ey + 0.4), 0.4, 0.4, edgecolor='black', facecolor=color))
    ax.text(ex + 0.2, ey + 0.6, e_id, fontsize=9, color='white', ha='center', va='center')

# Add legend
ax.legend(handles=legend_elements, loc='upper right')

# Set limits and hide axes
ax.set_xlim(0, floor_width)
ax.set_ylim(0, num_floors * floor_height)
ax.axis('off')

# Save the figure
plt.savefig('elevator/one_shot/ini_diagram_code/attempts/attempt_25.png', bbox_inches='tight')
plt.close()